#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "a.h"
#include "Parser.h"
#include "ParserIO.h"


class IOC : public ParserIO
{
public:
	int read_text(char *s,int *l) {
		int i;

		*l = read(0, s, *l);
		if (*l > -1)
			s[*l] = 0;
		while (strlen(s) && (s[strlen(s) - 1] == 13 || s[strlen(s) - 1] == 10))
			s[strlen(s) - 1] = 0;
		for (i = 0; i < (int)strlen(s); i++)
			if (s[i] >= 'a' && s[i] <= 'z')
				s[i] -= 32;
		return *l;
	}
	int write_text(char *s,int l) {
		s[l] = 0;
		printf("%s",s);
		fflush(stdout);
		return 0;
	}
};


int main(int argc,char *argv[])
{
	Parser cmdline;
	IOC ioc;
	int n;
	char slask[200];

	cmdline.SetParserIO(&ioc);
	ioc.m_more = 1;

	if (argc > 1)
	{
		sprintf(slask,"RUN %s",argv[1]);
		cmdline.cmd( slask );
		return 0;
	}

	printf("Welcome to asexec, the linux applesoft interpreter\n");
	*slask = 0;
	while ( strncasecmp(slask,"quit",4) )
	{
		cmdline.flush_obuf();
		printf("\n>");
		fflush(stdout);
		if ( (n = read(0, slask, 200)) == -1)
		{
			perror("read() failed");
			exit(-1);
		}
		slask[n] = 0;
		if (strncasecmp(slask,"quit",4))
		{
			cmdline.cmd( slask );
		}
	}
	printf("Exit from asexec\n");
	return 0;
}

